/****************************************************************************
 * NCSA Mosaic for the X Window System                                      *
 * Software Development Group                                               *
 * National Center for Supercomputing Applications                          *
 * University of Illinois at Urbana-Champaign                               *
 * 605 E. Springfield, Champaign IL 61820                                   *
 * mosaic@ncsa.uiuc.edu                                                     *
 *                                                                          *
 * Copyright (C) 1993, Board of Trustees of the University of Illinois      *
 *                                                                          *
 * NCSA Mosaic software, both binary and source (hereafter, Software) is    *
 * copyrighted by The Board of Trustees of the University of Illinois       *
 * (UI), and ownership remains with the UI.                                 *
 *                                                                          *
 * The UI grants you (hereafter, Licensee) a license to use the Software    *
 * for academic, research and internal business purposes only, without a    *
 * fee.  Licensee may distribute the binary and source code (if released)   *
 * to third parties provided that the copyright notice and this statement   *
 * appears on all copies and that no charge is associated with such         *
 * copies.                                                                  *
 *                                                                          *
 * Licensee may make derivative works.  However, if Licensee distributes    *
 * any derivative work based on or derived from the Software, then          *
 * Licensee will (1) notify NCSA regarding its distribution of the          *
 * derivative work, and (2) clearly notify users that such derivative       *
 * work is a modified version and not the original NCSA Mosaic              *
 * distributed by the UI.                                                   *
 *                                                                          *
 * Any Licensee wishing to make commercial use of the Software should       *
 * contact the UI, c/o NCSA, to negotiate an appropriate license for such   *
 * commercial use.  Commercial use includes (1) integration of all or       *
 * part of the source code into a product for sale or license by or on      *
 * behalf of Licensee to third parties, or (2) distribution of the binary   *
 * code or source code to third parties that need it to utilize a           *
 * commercial product sold or licensed by or on behalf of Licensee.         *
 *                                                                          *
 * UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR   *
 * ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED          *
 * WARRANTY.  THE UI SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY THE    *
 * USERS OF THIS SOFTWARE.                                                  *
 *                                                                          *
 * By using or copying this Software, Licensee agrees to abide by the       *
 * copyright law and all other applicable laws of the U.S. including, but   *
 * not limited to, export control laws, and the terms of this license.      *
 * UI shall have the right to terminate this license immediately by         *
 * written notice upon Licensee's breach of, or non-compliance with, any    *
 * of its terms.  Licensee may be held legally responsible for any          *
 * copyright infringement that is caused or encouraged by Licensee's        *
 * failure to abide by the terms of this license.                           *
 *                                                                          *
 * Comments and questions are welcome and can be sent to                    *
 * mosaic-x@ncsa.uiuc.edu.                                                  *
 ****************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#ifdef DEBUG

char *strstrdup(char *src,char *srch,char *rplc);

int main() {

char *bob,*newstr;

	bob=strdup("This is test %d.");
	newstr=strstrdup(bob,"%d","1");

	printf("bob[%s]\nnew[%s]\n\n",bob,newstr);

	free(bob);
	free(newstr);

	bob=strdup("%d) This is test %d.");
	newstr=strstrdup(bob,"%d","2");

	printf("bob[%s]\nnew[%s]\n\n",bob,newstr);

	free(bob);
	free(newstr);

	bob=strdup("This is test %d.");
	newstr=strstrdup(bob,"%d","003");

	printf("bob[%s]\nnew[%s]\n\n",bob,newstr);

	bob=strdup("%d) This is test %d.");
	newstr=strstrdup(bob,"%d","004");

	printf("bob[%s]\nnew[%s]\n\n",bob,newstr);

	exit(0);
}
#endif


char *getFileName(char *file_src) {

char *ptr;

	if (!file_src || !*file_src) {
		return(NULL);
	}

	ptr=strrchr(file_src,'/');

	if (!ptr || !*ptr) {
		return(file_src);
	}

	if (*ptr=='/' && *(ptr+1)) {
		ptr++;
	}

	return(ptr);
}


char *strstrdup(char *src, char *srch, char *rplc) {

char *dest=NULL,*local=NULL,*start=NULL,*found=NULL,*next=NULL;
int rplcLen=0,i,srchLen;

	if (!src || !*src || !srch || !*srch) {
		return(NULL);
	}

	if (rplc && *rplc) {
		rplcLen=strlen(rplc);
	}
	srchLen=strlen(srch);

	if (rplcLen>srchLen) {
		dest=(char *)calloc(1,sizeof(char));
	}
	else {
		dest=strdup(src);
	}
	*dest='\0';

	local=strdup(src);
	start=local;
	while (*start) {
		if (!(found=strstr(start,srch))) {
			if (rplcLen>srchLen) {
				realloc((void *)dest,((strlen(dest)+strlen(start)+4)*sizeof(char)));
				strcat(dest,start);
			}
			else {
				strcat(dest,start);
			}
			free(local);

			return(dest);
		}

		for (i=0,next=found; i<srchLen; i++,next++);
		*found='\0';
		if (rplcLen>srchLen) {
			realloc((void *)dest,((rplcLen+strlen(dest)+strlen(start)+4)*sizeof(char)));
			strcat(dest,start);
			if (rplcLen) {
				strcat(dest,rplc);
			}
		}
		else {
			strcat(dest,start);
			strcat(dest,rplc);
		}
		start=next;
	}

	return(dest);
}


char **string_to_token_array(char *str, char *delimiter)
{
  char **array, *tmp;
  int num=0, i=0;

  if(!str || !*str || !delimiter || !*delimiter)
    return NULL;

  /* first get number of tokens */
  tmp = strstr(str, delimiter);
  num++; tmp++;
  while((tmp = strstr(tmp, delimiter)) != NULL)
    {
      tmp++; num++;
    }

  array = malloc(sizeof(char *) * (num+2));
  array[0] = strdup(strtok(str, delimiter));

  i++;
  while((array[i++] = strdup(strtok((char *) NULL, delimiter))) != NULL);


  free(str);
  return array;
}

char *my_strndup(char *str, int num)
{
  char *nstr = malloc(sizeof(char) * (num + 1));

  if(!str || !*str || !nstr)
    return NULL;

  strncpy(nstr, str, num);
  nstr[num] = '\0'; /* shouldn't strcpy do this ?? */
  return nstr;
}

char *my_chop(char *str)
{
  char *ptr;

  if(!str || !*str)
    return str;

  while(isspace(str[0]))
    str++;

  while(isspace(str[strlen(str)-1]) || isspace(str[strlen(str)-1]))
    {
      str[strlen(str)-1] = '\0';
    }

  return str;
}
